/*{{{  module header */
/*
-- ----------------------------------------------------------------------------
--
--     Object Name : imsmisc.h
--     Revision    : 1
--
--     (c) Copyright INMOS Limited 1990.
--     All Rights Reserved.
--
--     DESCRIPTION
--         Standard INMOS header file for useful definitions.
--
--     NOTES
--         None.
--
--     HISTORY
--         1-Aug-1990    Antony King    Created file.
--         1-Nov-1990    Antony King    Last change.
--
-- ----------------------------------------------------------------------------
*/
/*}}}*/

#ifndef _IMSMISCH
/*{{{  not included header file */
#define _IMSMISCH

/*{{{  C scope definitions */
#define PUBLIC
#define PRIVATE  static
#define EXTERNAL extern
#define FORWARD
#define EXTERN   extern
/*}}}*/

/*{{{  constant definitions */
#define MAX_STRING_SIZE 256
#define MAX_BLOCK_SIZE  1024
/*}}}*/

/*{{{  host compiler macros */
/*{{{  MS C specific macros */
#ifdef MSC
/*{{{   */
#define ANSI /* ANSI C conformant compiler */

#define MS_DOS

#define PRIVATEPARAM PRIVATE
/*}}}*/
#endif
/*}}}*/

/*{{{  DEC C specific macros */
#ifdef DEC
/*{{{   */
#define ANSI /* ANSI C conformant compiler */

#define VMS_OS

#define PRIVATEPARAM PRIVATE
/*}}}*/
#endif
/*}}}*/

/*{{{  3L C specific macros */
#ifdef LLL
/*{{{   */
#define SERVER

#define PRIVATEPARAM
/*}}}*/
#endif
/*}}}*/

/*{{{  GNU C specific macros */
#ifdef GNU
/*{{{   */
#define ANSI /* ANSI C conformant compiler */

#define SUN_OS

#define PRIVATEPARAM PRIVATE
/*}}}*/
#endif
/*}}}*/

/*{{{  SUN C specific macros */
#ifdef SUN
/*{{{   */
#define SUN_OS

#define PRIVATEPARAM PRIVATE
/*}}}*/
#endif
/*}}}*/

/*{{{  IMS C specific macros */
#ifdef IMS
/*{{{   */
#define ANSI /* ANSI C conformant compiler */

#define SERVER

#define PRIVATEPARAM PRIVATE
/*}}}*/
#endif
/*}}}*/
/*}}}*/

/*{{{  C portability macros */
#ifdef ANSI
/*{{{   */
#define PARMS(X) X

#define VAL const
/*}}}*/
#else
/*{{{   */
#define PARMS(X) ()

#define VAL
/*}}}*/
#endif
/*}}}*/
/*}}}*/
#endif
