#ifndef _EXTLIBH
/*{{{  not included header file */
#define _EXTLIBH

/*{{{  standard includes */
#include "imstype.h"
#include "imsmisc.h"
#include "imsstd.h"
/*}}}*/

/*{{{  constant definitions */
/*{{{  operation and rounding codes */
#define Truncate 0 /* Conversion mode to round to zero */
#define Nearest  1 /* Conversion mode to round to nearest */

#define OpMask  3 /* Extract Rounding Mode and Operation from RMOp */
#define RMShift 2

#define Op_Add 0 /* Operation code for addition */
#define Op_Sub 1 /* Operation code for subtraction */
#define Op_Mul 2 /* Operation code for multiplication */
#define Op_Div 3 /* Operation code for division */
#define Op_Rem 4 /* Operation code for remainder, integers only */

#define RN 0 /* Round to nearest */
#define RZ 1 /* Round to zero */
#define RP 2 /* Round to +infinity */
#define RM 3 /* Round to -infinity */
/*}}}*/

/*{{{  IEEE floating point constants */
/*{{{  IEEE single length values */
#define RealShift     8
#define BitsInFrac    24
#define RealExpSh     23

#define RealExp       0X000000FFL
#define RealXcess     0X0000007FL
#define RealRBit      0X00000080L
#define BiggestFinite 0X7F7FFFFFL

#define RealInf       0X7F800000L
#define RealNaN       0X7F800001L

#define REAL32MININT32 0XCF000000L
#define REAL32MININT64 0XDF000000L
/*}}}*/

/*{{{  IEEE double length values */
#define DRealShift       11
#define DBitsInFrac      53
#define DRealExpSh       20

#define DRealExp         0X000007FFL
#define DRealXcess       0X000003FFL
#define DRealRBit        0X00000400L
#define DBiggestFiniteLo 0XFFFFFFFFL
#define DBiggestFiniteHi 0X7FEFFFFFL

#define DRealInf         0X7FF00000L
#define DRealNaNLo       0X00000001L
#define DRealNaNHi       DRealInf

#define REAL64MININT32Hi 0XC1E00000L
#define REAL64MININT64Hi 0XC2E00000L
/*}}}*/

/*{{{  IEEE NaNs for 32 bit reals */
#define ZeroZeroDivNaN  0X7FC00000L
#define InfInfDivNaN    0X7FA00000L
#define ZeroInfMulNaN   0X7F900000L
#define AddSubInfInfNaN 0X7F880000L
#define NegSqrtNaN      0X7F840000L
#define RemInfNaN       0X7F804000L
#define RemZeroNaN      0X7F802000L

#define Real64to32NaN     0X7F820000L
#define Real64to32NaNfrac 0X02000000L
/*}}}*/

/*{{{  IEEE NaNs for 64 bit reals */
#define DZeroZeroDivNaN  0X7FF80000L
#define DInfInfDivNaN    0X7FF40000L
#define DZeroInfMulNaN   0X7FF20000L
#define DAddSubInfInfNaN 0X7FF10000L
#define DNegSqrtNaN      0X7FF08000L
#define DRemInfNaN       0X7FF00800L
#define DRemZeroNaN      0X7FF00400L

#define DReal64to32NaN   0X7FF04000L
/*}}}*/
/*}}}*/
/*}}}*/

/*{{{  routine prototypes */
/*{{{  extstr.c */
EXTERNAL VOID RealIMul PARMS((INT32 *, INT32 *, INT32, INT32));

EXTERNAL VOID RealIDiv PARMS((INT32 *, INT32 *, INT32 *, INT32 *, INT32 *));

EXTERNAL VOID StrToR64 PARMS((BOOL *, BIT32 *, BIT32 *, CHAR *));

EXTERNAL VOID StrToR32 PARMS((BOOL *, BIT32 *, CHAR *));

EXTERNAL VOID StrToInt PARMS((BOOL *, BIT32 *, CHAR *));

EXTERNAL VOID StrToI8 PARMS((BOOL *, BIT32 *, CHAR *));

EXTERNAL VOID StrToI16 PARMS((BOOL *, BIT32 *, CHAR *));

EXTERNAL VOID StrToI64 PARMS((BOOL *, BIT32 *, BIT32 *, CHAR *));

EXTERNAL VOID StrToHex PARMS((BOOL *, BIT32 *, CHAR *));

EXTERNAL VOID StrToH8 PARMS((BOOL *, BIT32 *, CHAR *));

EXTERNAL VOID StrToH16 PARMS((BOOL *, BIT32 *, CHAR *));

EXTERNAL VOID StrToH64 PARMS((BOOL *, BIT32 *, BIT32 *, CHAR *));

EXTERNAL VOID StrToOct PARMS((BOOL *, BIT32 *, CHAR *));
/*}}}*/

/*{{{  extlong.c */
EXTERNAL VOID LONGSUM PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32));

EXTERNAL VOID LONGADD PARMS((BIT32 *, BIT32, BIT32, BIT32));

EXTERNAL VOID LONGDIFF PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32));

EXTERNAL VOID LONGPROD PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32));

EXTERNAL VOID LONGDIV PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32));

EXTERNAL VOID SHIFTRIGHT PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32));

EXTERNAL VOID SHIFTLEFT PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32));

EXTERNAL VOID NORMALISE PARMS((BIT32 *, BIT32 *, BIT32 *, BIT32, BIT32));
/*}}}*/

/*{{{  extconv.c */
EXTERNAL VOID I32ToI64 PARMS((BIT32 *, BIT32 *, BIT32));

EXTERNAL VOID I32ToR32 PARMS((BIT32 *, INT, BIT32));

EXTERNAL VOID I32ToR64 PARMS((BIT32 *, BIT32 *, BIT32));

EXTERNAL VOID I64ToI32 PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID I64ToR32 PARMS((BIT32 *, INT, BIT32, BIT32));

EXTERNAL VOID I64ToR64 PARMS((BIT32 *, BIT32 *, INT, BIT32, BIT32));

EXTERNAL VOID R32ToI32 PARMS((BOOL *, BIT32 *, INT, BIT32));

EXTERNAL VOID R32ToI64 PARMS((BOOL *, BIT32 *, BIT32 *, INT, BIT32));

EXTERNAL VOID R32ToR64 PARMS((BOOL *, BIT32 *, BIT32 *, BIT32));

EXTERNAL VOID R64ToI32 PARMS((BOOL *, BIT32 *, INT, BIT32, BIT32));

EXTERNAL VOID R64ToI64 PARMS((BOOL *, BIT32 *, BIT32 *, INT, BIT32, BIT32));

EXTERNAL VOID R64ToR32 PARMS((BOOL *, BIT32 *, INT, BIT32, BIT32));
/*}}}*/

/*{{{  exti8.c */
EXTERNAL VOID Int8Add PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8Plus PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8Sub PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8Minus PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8Mul PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8Times PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8Div PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8Rem PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8Eq PARMS((BOOL *, BIT32, BIT32));

EXTERNAL VOID Int8Gt PARMS((BOOL *, BIT32, BIT32));

EXTERNAL VOID Int8BitAnd PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8BitOr PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8Xor PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8BitNot PARMS((BIT32 *, BIT32));

EXTERNAL VOID Int8LShift PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int8RShift PARMS((BIT32 *, BIT32, BIT32));
/*}}}*/

/*{{{  exti16.c */
EXTERNAL VOID Int16Add PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16Plus PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16Sub PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16Minus PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16Mul PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16Times PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16Div PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16Rem PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16Eq PARMS((BOOL *, BIT32, BIT32));

EXTERNAL VOID Int16Gt PARMS((BOOL *, BIT32, BIT32));

EXTERNAL VOID Int16BitAnd PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16BitOr PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16Xor PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16BitNot PARMS((BIT32 *, BIT32));

EXTERNAL VOID Int16LShift PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int16RShift PARMS((BIT32 *, BIT32, BIT32));
/*}}}*/

/*{{{  exti32.c */
EXTERNAL VOID Int32Add PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32Plus PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32Sub PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32Minus PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32Mul PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32Times PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32Div PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32Rem PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32Eq PARMS((BOOL *, BIT32, BIT32));

EXTERNAL VOID Int32Gt PARMS((BOOL *, BIT32, BIT32));

EXTERNAL VOID Int32BitAnd PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32BitOr PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32Xor PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32BitNot PARMS((BIT32 *, BIT32));

EXTERNAL VOID Int32LShift PARMS((BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int32RShift PARMS((BIT32 *, BIT32, BIT32));
/*}}}*/

/*{{{  exti64.c */
EXTERNAL VOID Int64Add PARMS((BOOL *, BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64Plus PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64Sub PARMS((BOOL *, BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64Minus PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64Mul PARMS((BOOL *, BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64Times PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64Div PARMS((BOOL *, BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64Rem PARMS((BOOL *, BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64Eq PARMS((BOOL *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64Gt PARMS((BOOL *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64BitAnd PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64BitOr PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64Xor PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64BitNot PARMS((BIT32 *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Int64LShift PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32));

EXTERNAL VOID Int64RShift PARMS((BIT32 *, BIT32 *, BIT32, BIT32, BIT32));
/*}}}*/

/*{{{  extr32.c */
EXTERNAL VOID Real32Op PARMS((BOOL *, BIT32 *, BIT32, INT, BIT32));

EXTERNAL VOID Real32Rem PARMS((BOOL *, BIT32 *, BIT32, BIT32));

EXTERNAL VOID Real32Eq PARMS((BOOL *, BIT32, BIT32));

EXTERNAL VOID Real32Gt PARMS((BOOL *, BIT32, BIT32));
/*}}}*/

/*{{{  extr64.c */
EXTERNAL VOID Real64Op PARMS((BOOL *, BIT32 *, BIT32 *, BIT32, BIT32, INT, BIT32, BIT32));

EXTERNAL VOID Real64Rem PARMS((BOOL *, BIT32 *, BIT32 *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Real64Eq PARMS((BOOL *, BIT32, BIT32, BIT32, BIT32));

EXTERNAL VOID Real64Gt PARMS((BOOL *, BIT32, BIT32, BIT32, BIT32));
/*}}}*/
/*}}}*/
/*}}}*/
#endif
