#include "extlib.h"

/*{{{  global procedures */
/*{{{  LONGSUM */
#ifdef ANSI
PUBLIC VOID LONGSUM (BIT32 *CarryOut, BIT32 *Sum, BIT32 Left, BIT32 Right, BIT32 CarryIn)
#else
PUBLIC VOID LONGSUM (CarryOut, Sum, Left, Right, CarryIn)
    BIT32 *CarryOut, *Sum, Left, Right, CarryIn;
#endif
{
    CarryIn &= ONE32;

    if ((MaxUnsignedInt32 - Left) >= Right)
    {
        /*{{{   */
        *Sum = Left + Right;
        
        if ((CarryIn != ZERO32) && (*Sum == MaxUnsignedInt32))
        {
            /*{{{   */
            *Sum = ZERO32;
            *CarryOut = ONE32;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            *Sum = *Sum + CarryIn;
            *CarryOut = ZERO32;
            /*}}}*/
        }
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *CarryOut = ONE32;
        *Sum = (Right - ((MaxUnsignedInt32 - Left) + ONE32)) + CarryIn;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  LONGADD */
#ifdef ANSI
PUBLIC VOID LONGADD (BIT32 *Sum, BIT32 Left, BIT32 Right, BIT32 CarryIn)
#else
PUBLIC VOID LONGADD (Sum, Left, Right, CarryIn)
    BIT32 *Sum, Left, Right, CarryIn;
#endif
{
    *Sum = Left + (Right + (CarryIn & ONE32));
}
/*}}}*/

/*{{{  LONGDIFF */
#ifdef ANSI
PUBLIC VOID LONGDIFF (BIT32 *BorrowOut, BIT32 *Diff, BIT32 Left, BIT32 Right, BIT32 BorrowIn)
#else
PUBLIC VOID LONGDIFF (BorrowOut, Diff, Left, Right, BorrowIn)
    BIT32 *BorrowOut, *Diff, Left, Right, BorrowIn;
#endif
{
    BorrowIn &= ONE32;
    *BorrowOut = ZERO32;

    if (Left >= Right)
        *Diff = Left - Right;
    else
    {
        /*{{{   */
        *Diff = MaxUnsignedInt32 - Right;
        *Diff = (*Diff + Left) + ONE32;
        *BorrowOut = ONE32;
        /*}}}*/
    }

    if (BorrowIn != ZERO32)
    {
        /*{{{   */
        if (*Diff > ZERO32)
            (*Diff)--;
        else
        {
            /*{{{   */
            *Diff = MaxUnsignedInt32;
            *BorrowOut = ONE32;
            /*}}}*/
        }
        /*}}}*/
    }
}
/*}}}*/

/*{{{  LONGPROD */
#ifdef ANSI
PUBLIC VOID LONGPROD (BIT32 *ProdHi, BIT32 *ProdLo, BIT32 Left, BIT32 Right, BIT32 CarryIn)
#else
PUBLIC VOID LONGPROD (ProdHi, ProdLo, Left, Right, CarryIn)
    BIT32 *ProdHi, *ProdLo, Left, Right, CarryIn;
#endif
{
    BIT32 Temp1, Temp2, Temp3, Temp4, TempLo, TempHi, Carry;

    Temp1 = Left & LowBits16;          /* Left MOD 2^16 */
    Temp2 = (Left >> 16) & LowBits16;  /* Left DIV 2^16 */
    Temp3 = Right & LowBits16;         /* Right MOD 2^16 */
    Temp4 = (Right >> 16) & LowBits16; /* Right DIV 2^16 */

    *ProdLo = Temp1 * Temp3;
    TempLo = Temp2 * Temp3;
    TempHi = (TempLo >> 16) & LowBits16;
    TempLo = TempLo << 16;

    LONGSUM(ProdHi, ProdLo, *ProdLo, TempLo, ZERO32);

    *ProdHi = *ProdHi + TempHi;
    TempLo = Temp1 * Temp4;
    TempHi = (TempLo >> 16) & LowBits16;
    TempLo = TempLo << 16;

    LONGSUM(&Carry, ProdLo, *ProdLo, TempLo, ZERO32);

    *ProdHi = (*ProdHi + Carry) + TempHi;

    LONGSUM(&Carry, ProdLo, *ProdLo, CarryIn, ZERO32);

    *ProdHi = (*ProdHi + Carry) + (Temp2 * Temp4);
}
/*}}}*/

/*{{{  LONGDIV */
#ifdef ANSI
PUBLIC VOID LONGDIV (BIT32 *Quot, BIT32 *Rem, BIT32 DividHi, BIT32 DividLo, BIT32 Divis)
#else
PUBLIC VOID LONGDIV (Quot, Rem, DividHi, DividLo, Divis)
    BIT32 *Quot, *Rem, DividHi, DividLo, Divis;
#endif
{
    if (Divis == ZERO32)
    {
        /*{{{   */
        *Quot = ZERO32;
        *Rem = ZERO32;
        /*}}}*/
    }
    else if ((DividHi == ZERO32) && (DividLo == ZERO32))
    {
        /*{{{   */
        *Quot = ZERO32;
        *Rem = ZERO32;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        INT BitCount;
        BIT32 Places, RemHi, RemLo, QuotHi, QuotLo;
        
        RemHi = ZERO32;
        RemLo = ZERO32;
        QuotHi = DividHi;
        QuotLo = DividLo;
        
        NORMALISE(&Places, &QuotHi, &QuotLo, QuotHi, QuotLo);
        
        BitCount = 64 - ((INT) Places);
        do
        {
            /*{{{   */
            SHIFTLEFT(&RemHi, &RemLo, RemHi, RemLo, ONE32);
            
            if ((QuotHi & SignBit32) != ZERO32)
                RemLo++;
            
            SHIFTLEFT(&QuotHi, &QuotLo, QuotHi, QuotLo, ONE32);
            
            if ((RemHi > ZERO32) || ((RemHi == ZERO32) && (RemLo >= Divis)))
            {
                /*{{{   */
                BIT32 Borrow;
                
                LONGDIFF(&Borrow, &RemLo, RemLo, Divis, ZERO32);
                LONGDIFF(&Borrow, &RemHi, RemHi, ZERO32, Borrow);
                QuotLo++;
                /*}}}*/
            }
            
            BitCount--;
            /*}}}*/
        }
        while (BitCount > ZERO32);
        
        *Quot = QuotLo;
        *Rem = RemLo;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  SHIFTRIGHT */
#ifdef ANSI
PUBLIC VOID SHIFTRIGHT (BIT32 *OutHi, BIT32 *OutLo, BIT32 InHi, BIT32 InLo, BIT32 Places)
#else
PUBLIC VOID SHIFTRIGHT (OutHi, OutLo, InHi, InLo, Places)
    BIT32 *OutHi, *OutLo, InHi, InLo, Places;
#endif
{
    if (Places >= 64)
    {
        /*{{{   */
        *OutHi = ZERO32;
        *OutLo = ZERO32;
        /*}}}*/
    }
    else if (Places >= 32)
    {
        /*{{{   */
        *OutHi = ZERO32;
        *OutLo = InHi >> (Places - 32);
        /*}}}*/
    }
    else if (Places == ZERO32)
    {
        /*{{{   */
        *OutLo = InLo;
        *OutHi = InHi;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *OutLo = (InLo >> Places) | (InHi << (32 - Places));
        *OutHi = InHi >> Places;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  SHIFTLEFT */
#ifdef ANSI
PUBLIC VOID SHIFTLEFT (BIT32 *OutHi, BIT32 *OutLo, BIT32 InHi, BIT32 InLo, BIT32 Places)
#else
PUBLIC VOID SHIFTLEFT (OutHi, OutLo, InHi, InLo, Places)
    BIT32 *OutHi, *OutLo, InHi, InLo, Places;
#endif
{
    if (Places >= 64)
    {
        /*{{{   */
        *OutHi = ZERO32;
        *OutLo = ZERO32;
        /*}}}*/
    }
    else if (Places >= 32)
    {
        /*{{{   */
        *OutLo = ZERO32;
        *OutHi = InLo << (Places - 32);
        /*}}}*/
    }
    else if (Places == ZERO32)
    {
        /*{{{   */
        *OutLo = InLo;
        *OutHi = InHi;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *OutHi = (InHi << Places) | (InLo >> (32 - Places));
        *OutLo = InLo << Places;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  NORMALISE */
#ifdef ANSI
PUBLIC VOID NORMALISE (BIT32 *Places, BIT32 *OutHi, BIT32 *OutLo, BIT32 InHi, BIT32 InLo)
#else
PUBLIC VOID NORMALISE (Places, OutHi, OutLo, InHi, InLo)
    BIT32 *Places, *OutHi, *OutLo, InHi, InLo;
#endif
{
    if ((InHi == ZERO32) && (InLo == ZERO32))
    {
        /*{{{   */
        *Places = 64;
        *OutHi = ZERO32;
        *OutLo = ZERO32;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *Places = ZERO32;
        *OutHi = InHi;
        *OutLo = InLo;
        
        while ((*OutHi & SignBit32) == ZERO32)
        {
            /*{{{   */
            SHIFTLEFT(OutHi, OutLo, *OutHi, *OutLo, ONE32);
            (*Places)++;
            /*}}}*/
        }
        /*}}}*/
    }
}
/*}}}*/
/*}}}*/
