#include "extlib.h"

/*{{{  global procedures */
/*{{{  Int8Add */
#ifdef ANSI
PUBLIC VOID Int8Add (BOOL *Error, BIT32 *Sum, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Add (Error, Sum, A, B)
    BOOL *Error;
    BIT32 *Sum, A, B;
#endif
{
    *Sum = A + B;

    *Error = ((*Sum & HighBits8) != ZERO32);
}
/*}}}*/

/*{{{  Int8Plus */
#ifdef ANSI
PUBLIC VOID Int8Plus (BIT32 *Sum, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Plus (Sum, A, B)
    BIT32 *Sum, A, B;
#endif
{
    *Sum = (A + B) & LowBits8;
}
/*}}}*/

/*{{{  Int8Sub */
#ifdef ANSI
PUBLIC VOID Int8Sub (BOOL *Error, BIT32 *Diff, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Sub (Error, Diff, A, B)
    BOOL *Error;
    BIT32 *Diff, A, B;
#endif
{
    *Diff = A - B;

    *Error = ((*Diff & HighBits8) != ZERO32);
}
/*}}}*/

/*{{{  Int8Minus */
#ifdef ANSI
PUBLIC VOID Int8Minus (BIT32 *Diff, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Minus (Diff, A, B)
    BIT32 *Diff, A, B;
#endif
{
    *Diff = (A - B) & LowBits8;
}
/*}}}*/

/*{{{  Int8Mul */
#ifdef ANSI
PUBLIC VOID Int8Mul (BOOL *Error, BIT32 *Prod, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Mul (Error, Prod, A, B)
    BOOL *Error;
    BIT32 *Prod, A, B;
#endif
{
    *Prod = A * B;

    *Error = ((*Prod & HighBits8) != ZERO32);
}
/*}}}*/

/*{{{  Int8Times */
#ifdef ANSI
PUBLIC VOID Int8Times (BIT32 *Prod, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Times (Prod, A, B)
    BIT32 *Prod, A, B;
#endif
{
    *Prod = (A * B) & LowBits8;
}
/*}}}*/

/*{{{  Int8Div */
#ifdef ANSI
PUBLIC VOID Int8Div (BOOL *Error, BIT32 *Quot, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Div (Error, Quot, A, B)
    BOOL *Error;
    BIT32 *Quot, A, B;
#endif
{
    if (B == ZERO32)
        *Error = TRUE;
    else
    {
        /*{{{   */
        *Quot = (INT32) A / (INT32) B;
        
        *Error = ((*Quot & HighBits8) != ZERO32);
        /*}}}*/
    }
}
/*}}}*/

/*{{{  Int8Rem */
#ifdef ANSI
PUBLIC VOID Int8Rem (BOOL *Error, BIT32 *Rem, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Rem (Error, Rem, A, B)
    BOOL *Error;
    BIT32 *Rem, A, B;
#endif
{
    if (B == ZERO32)
        *Error = TRUE;
    else
    {
        /*{{{   */
        *Rem = (INT32) A % (INT32) B;
        
        *Error = ((*Rem & HighBits8) != ZERO32);
        /*}}}*/
    }
}
/*}}}*/

/*{{{  Int8Eq */
#ifdef ANSI
PUBLIC VOID Int8Eq (BOOL *Equal, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Eq (Equal, A, B)
    BOOL *Equal;
    BIT32 A, B;
#endif
{
    *Equal = (A == B);
}
/*}}}*/

/*{{{  Int8Gt */
#ifdef ANSI
PUBLIC VOID Int8Gt (BOOL *Greater, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Gt (Greater, A, B)
    BOOL *Greater;
    BIT32 A, B;
#endif
{
    *Greater = (A > B);
}
/*}}}*/

/*{{{  Int8BitAnd */
#ifdef ANSI
PUBLIC VOID Int8BitAnd (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8BitAnd (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = A & B;
}
/*}}}*/

/*{{{  Int8BitOr */
#ifdef ANSI
PUBLIC VOID Int8BitOr (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8BitOr (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = A | B;
}
/*}}}*/

/*{{{  Int8Xor */
#ifdef ANSI
PUBLIC VOID Int8Xor (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8Xor (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = A ^ B;
}
/*}}}*/

/*{{{  Int8BitNot */
#ifdef ANSI
PUBLIC VOID Int8BitNot (BIT32 *Res, BIT32 A)
#else
PUBLIC VOID Int8BitNot (Res, A)
    BIT32 *Res, A;
#endif
{
    *Res = ~A & LowBits8;
}
/*}}}*/

/*{{{  Int8LShift */
#ifdef ANSI
PUBLIC VOID Int8LShift (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8LShift (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = (B > 7) ? ZERO32 : ((B == ZERO32) ? A : (A << B));
}
/*}}}*/

/*{{{  Int8RSHift */
#ifdef ANSI
PUBLIC VOID Int8RShift (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int8RShift (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = (B > 7) ? ZERO32 : ((B == ZERO32) ? A : (A >> B));
}
/*}}}*/
/*}}}*/
