#include "extlib.h"

/*{{{  global procedures */
/*{{{  Int32Add */
#ifdef ANSI
PUBLIC VOID Int32Add (BOOL *Error, BIT32 *Sum, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Add (Error, Sum, A, B)
    BOOL *Error;
    BIT32 *Sum, A, B;
#endif
{
    *Sum = A + B;

    *Error = ((((A ^ B) & SignBit32) == ZERO32) &&
              (((A ^ *Sum) & SignBit32) != ZERO32));
}
/*}}}*/

/*{{{  Int32Plus */
#ifdef ANSI
PUBLIC VOID Int32Plus (BIT32 *Sum, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Plus (Sum, A, B)
    BIT32 *Sum, A, B;
#endif
{
    *Sum = A + B;
}
/*}}}*/

/*{{{  Int32Sub */
#ifdef ANSI
PUBLIC VOID Int32Sub (BOOL *Error, BIT32 *Diff, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Sub (Error, Diff, A, B)
    BOOL *Error;
    BIT32 *Diff, A, B;
#endif
{
    *Diff = A - B;

    *Error = ((((A ^ B) & SignBit32) != ZERO32) &&
              (((A ^ *Diff) & SignBit32) != ZERO32));
}
/*}}}*/

/*{{{  Int32Minus */
#ifdef ANSI
PUBLIC VOID Int32Minus (BIT32 *Diff, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Minus (Diff, A, B)
    BIT32 *Diff, A, B;
#endif
{
    *Diff = A - B;
}
/*}}}*/

/*{{{  Int32Mul */
#ifdef ANSI
PUBLIC VOID Int32Mul (BOOL *Error, BIT32 *Prod, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Mul (Error, Prod, A, B)
    BOOL *Error;
    BIT32 *Prod, A, B;
#endif
{
    BIT32 ProdHi;
    BOOL Negative;

    /*{{{  convert A and B to positive values */
    Negative = (((A ^ B) & SignBit32) != ZERO32);
    
    if ((A & SignBit32) != ZERO32)
        A = ~A + ONE32;
    if ((B & SignBit32) != ZERO32)
        B = ~B + ONE32;
    /*}}}*/

    LONGPROD(&ProdHi, Prod, A, B, ZERO32);

    if ((ProdHi != ZERO32) || ((*Prod & SignBit32) != ZERO32))
        *Error = TRUE;
    else
    {
        /*{{{   */
        *Error = FALSE;
        
        if (Negative)
            *Prod = ~*Prod + ONE32;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  Int32Times */
#ifdef ANSI
PUBLIC VOID Int32Times (BIT32 *Prod, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Times (Prod, A, B)
    BIT32 *Prod, A, B;
#endif
{
    *Prod = A * B;
}
/*}}}*/

/*{{{  Int32Div */
#ifdef ANSI
PUBLIC VOID Int32Div (BOOL *Error, BIT32 *Quot, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Div (Error, Quot, A, B)
    BOOL *Error;
    BIT32 *Quot, A, B;
#endif
{
    if (B == ZERO32)
        *Error = TRUE;
    else
    {
        /*{{{   */
        if ((A == SignBit32) && (B == -ONE32))
            *Error = TRUE;
        else
        {
            /*{{{   */
            *Error = FALSE;
            *Quot = (INT32) A / (INT32) B;
            /*}}}*/
        }
        /*}}}*/
    }
}
/*}}}*/

/*{{{  Int32Rem */
#ifdef ANSI
PUBLIC VOID Int32Rem (BOOL *Error, BIT32 *Rem, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Rem (Error, Rem, A, B)
    BOOL *Error;
    BIT32 *Rem, A, B;
#endif
{
    if (B == ZERO32)
        *Error = TRUE;
    else
    {
        /*{{{   */
        *Error = FALSE;
        
        if ((A == SignBit32) && (B == -ONE32))
            *Rem = ZERO32;
        else
            *Rem = (INT32) A % (INT32) B;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  Int32Eq */
#ifdef ANSI
PUBLIC VOID Int32Eq (BOOL *Equal, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Eq (Equal, A, B)
    BOOL *Equal;
    BIT32 A, B;
#endif
{
    *Equal = (A == B);
}
/*}}}*/

/*{{{  Int32Gt */
#ifdef ANSI
PUBLIC VOID Int32Gt (BOOL *Greater, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Gt (Greater, A, B)
    BOOL *Greater;
    BIT32 A, B;
#endif
{
    *Greater = ((INT32) A > (INT32) B);
}
/*}}}*/

/*{{{  Int32BitAnd */
#ifdef ANSI
PUBLIC VOID Int32BitAnd (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32BitAnd (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = A & B;
}
/*}}}*/

/*{{{  Int32BitOr */
#ifdef ANSI
PUBLIC VOID Int32BitOr (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32BitOr (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = A | B;
}
/*}}}*/

/*{{{  Int32Xor */
#ifdef ANSI
PUBLIC VOID Int32Xor (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32Xor (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = A ^ B;
}
/*}}}*/

/*{{{  Int32BitNot */
#ifdef ANSI
PUBLIC VOID Int32BitNot (BIT32 *Res, BIT32 A)
#else
PUBLIC VOID Int32BitNot (Res, A)
    BIT32 *Res, A;
#endif
{
    *Res = ~A;
}
/*}}}*/

/*{{{  Int32LShift */
#ifdef ANSI
PUBLIC VOID Int32LShift (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32LShift (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = (B > 31) ? ZERO32 : ((B == ZERO32) ? A : (A << B));
}
/*}}}*/

/*{{{  Int32RShift */
#ifdef ANSI
PUBLIC VOID Int32RShift (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int32RShift (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = (B > 31) ? ZERO32 : ((B == ZERO32) ? A : (A >> B));
}
/*}}}*/
/*}}}*/
