#include "extlib.h"

/*{{{  global procedures */
/*{{{  Int16Add */
#ifdef ANSI
PUBLIC VOID Int16Add (BOOL *Error, BIT32 *Sum, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Add (Error, Sum, A, B)
    BOOL *Error;
    BIT32 *Sum, A, B;
#endif
{
    *Sum = A + B;

    *Error = (((*Sum & HighBits16) != ZERO32) &&
              ((*Sum & HighBits16) != HighBits16));
}
/*}}}*/

/*{{{  Int16Plus */
#ifdef ANSI
PUBLIC VOID Int16Plus (BIT32 *Sum, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Plus (Sum, A, B)
    BIT32 *Sum, A, B;
#endif
{
    *Sum = (A + B) & LowBits16;

    if ((*Sum & SignBit16) != ZERO32)
        *Sum |= HighBits16;
}
/*}}}*/

/*{{{  Int16Sub */
#ifdef ANSI
PUBLIC VOID Int16Sub (BOOL *Error, BIT32 *Diff, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Sub (Error, Diff, A, B)
    BOOL *Error;
    BIT32 *Diff, A, B;
#endif
{
    *Diff = A - B;

    *Error = (((*Diff & HighBits16) != ZERO32) &&
              ((*Diff & HighBits16) != HighBits16));
}
/*}}}*/

/*{{{  Int16Minus */
#ifdef ANSI
PUBLIC VOID Int16Minus (BIT32 *Diff, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Minus (Diff, A, B)
    BIT32 *Diff, A, B;
#endif
{
    *Diff = (A - B) & LowBits16;

    if ((*Diff & SignBit16) != ZERO32)
        *Diff |= HighBits16;
}
/*}}}*/

/*{{{  Int16Mul */
#ifdef ANSI
PUBLIC VOID Int16Mul (BOOL *Error, BIT32 *Prod, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Mul (Error, Prod, A, B)
    BOOL *Error;
    BIT32 *Prod, A, B;
#endif
{
    *Prod = A * B;

    *Error = (((*Prod & HighBits16) != ZERO32) &&
              ((*Prod & HighBits16) != HighBits16));
}
/*}}}*/

/*{{{  Int16Times */
#ifdef ANSI
PUBLIC VOID Int16Times (BIT32 *Prod, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Times (Prod, A, B)
    BIT32 *Prod, A, B;
#endif
{
    *Prod = (A * B) & LowBits16;

    if ((*Prod & SignBit16) != ZERO32)
        *Prod |= HighBits16;
}
/*}}}*/

/*{{{  Int16Div */
#ifdef ANSI
PUBLIC VOID Int16Div (BOOL *Error, BIT32 *Quot, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Div (Error, Quot, A, B)
    BOOL *Error;
    BIT32 *Quot, A, B;
#endif
{
    if (B == ZERO32)
        *Error = TRUE;
    else
    {
        /*{{{   */
        *Quot = (INT32) A / (INT32) B;
        
        *Error = (((*Quot & HighBits16) != ZERO32) &&
                  ((*Quot & HighBits16) != HighBits16));
        /*}}}*/
    }
}
/*}}}*/

/*{{{  Int16Rem */
#ifdef ANSI
PUBLIC VOID Int16Rem (BOOL *Error, BIT32 *Rem, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Rem (Error, Rem, A, B)
    BOOL *Error;
    BIT32 *Rem, A, B;
#endif
{
    if (B == ZERO32)
        *Error = TRUE;
    else
    {
        /*{{{   */
        *Rem = (INT32) A % (INT32) B;
        
        *Error = (((*Rem & HighBits16) != ZERO32) &&
                  ((*Rem & HighBits16) != HighBits16));
        /*}}}*/
    }
}
/*}}}*/

/*{{{  Int16Eq */
#ifdef ANSI
PUBLIC VOID Int16Eq (BOOL *Equal, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Eq (Equal, A, B)
    BOOL *Equal;
    BIT32 A, B;
#endif
{
    *Equal = (A == B);
}
/*}}}*/

/*{{{  Int16Gt */
#ifdef ANSI
PUBLIC VOID Int16Gt (BOOL *Greater, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Gt (Greater, A, B)
    BOOL *Greater;
    BIT32 A, B;
#endif
{
    *Greater = ((INT32) A > (INT32) B);
}
/*}}}*/

/*{{{  Int16BitAnd */
#ifdef ANSI
PUBLIC VOID Int16BitAnd (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16BitAnd (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = A & B;
}
/*}}}*/

/*{{{  Int16BitOr */
#ifdef ANSI
PUBLIC VOID Int16BitOr (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16BitOr (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = A | B;
}
/*}}}*/

/*{{{  Int16Xor */
#ifdef ANSI
PUBLIC VOID Int16Xor (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16Xor (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = A ^ B;
}
/*}}}*/

/*{{{  Int16BitNot */
#ifdef ANSI
PUBLIC VOID Int16BitNot (BIT32 *Res, BIT32 A)
#else
PUBLIC VOID Int16BitNot (Res, A)
    BIT32 *Res, A;
#endif
{
    *Res = ~A;
}
/*}}}*/

/*{{{  Int16LShift */
#ifdef ANSI
PUBLIC VOID Int16LShift (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16LShift (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = (B > 15) ? ZERO32 : ((B == ZERO32) ? A : (A << B));
}
/*}}}*/

/*{{{  Int16RShift */
#ifdef ANSI
PUBLIC VOID Int16RShift (BIT32 *Res, BIT32 A, BIT32 B)
#else
PUBLIC VOID Int16RShift (Res, A, B)
    BIT32 *Res, A, B;
#endif
{
    *Res = (B > 15) ? ZERO32 : ((B == ZERO32) ? A : ((A & LowBits16) >> B));
}
/*}}}*/
/*}}}*/
