/* arg.h -- Define the structures for command line parsing */
/* Copyright Inmos 1989, 1990 */
/* Version 1.0 -- 19900129 */
/* History */
/* ahp: First version written */

typedef enum                  /* attributes of argument               */
  {
    arg_single    = 1,        /* just an argument on its own          */
    arg_operand   = 2,        /* argument has an operand              */
    arg_token     = 3,        /* function called if no prefix char    */
    arg_end       = 4,        /* last entry in table                  */
    arg_error     = 5,        /* error token found                    */
    arg_help      = 6         /* invoke if no arguments present       */
  }
   arg_options;
   
typedef enum
  {
    arg_continue  = 1,        /* continue after processing            */
    arg_terminate = 2         /* terminate immediately                */
  }
   arg_control;

typedef struct                /* descriptor of an argument            */
  {
    char *      arg_string;   /* string for argument                  */
    arg_options arg_type;     /* type of the argument                 */
    arg_control (*arg_fn)(char *);/* function to call for this argument   */
  }
   arg_descriptor;

/* arg_parse is a function that scans the arguments in tokenised form */
/* and calls the appropriate functions to process them.               */
/* At least one descriptor should contain the arg_error indicator     */
/* to show where to call if an error occurs.                          */
/* The last entry in the descriptor list must contain the arg_end     */
/* marker. If there is a function here, it is called at the end.      */

/* The functions that it calls all receive a (char *) argument. This  */
/* argument is the operand for those which require it, suitably       */
/* converted in case. In the case of an error, it contains the token  */
/* that could not be matched, or that was missing an operand. If no   */
/* error routine is given, then it is assumed that termination is the */
/* correct response. In other cases, the argument is a null pointer.  */
/* The user must free these arguments where necessary.                */

/* If any of these functions return arg_terminate, then the parser    */
/* stops immediately, freeing any of its own temporaries. It will     */
/* return arg_parse_error to the caller in this case.                 */

typedef enum
  {
    arg_parse_ok    = 0,      /* parse completed successfully         */
    arg_parse_error = 1,      /* error found during parsing           */
    arg_parse_help  = 2       /* help page was displayed              */
  }
   arg_parse_result;

arg_parse_result arg_parse
  (
    int const ,               /* number of tokens on command line     */
    char const * [],          /* token strings                        */
    arg_descriptor const []   /* description of expected arguments    */
  ) ;
