--{{{  copyright notice
--
-- Event library
--
-- $Source: /proj/kroc/develop/examples/syncs/RCS/event.inc,v $
--
-- $Id: event.inc,v 1.2 1997/03/30 20:51:54 djb1 Exp $
--
-- (C) Copyright 1996,1997 P.H.Welch <P.H.Welch@ukc.ac.uk> and
--                         D.C. Wood <D.C.Wood@ukc.ac.uk>
-- University of Kent at Canterbury, England
--
#COMMENT "$Id: event.inc,v 1.2 1997/03/30 20:51:54 djb1 Exp $"
--}}}

--{{{  DATA TYPE EVENT
DATA TYPE EVENT
  RECORD
    INT Fptr, Bptr:
    INT active, count:
:
--}}}

--{{{  constants
-- Local constants prefixed by EVENT. to prevent clashes

VAL INT EVENT.NotProcess.p IS MOSTNEG INT:
VAL INT EVENT.pw.Link IS -2:
--}}}

--{{{  INLINE PROC initialise.event (EVENT e, VAL INT count)
INLINE PROC initialise.event (EVENT e, VAL INT count)
  --{{{  
  e := [EVENT.NotProcess.p, EVENT.NotProcess.p, count, count]
  --}}}
:
--}}}

--{{{  INLINE PROC enroll.event (EVENT e, VAL INT count)
INLINE PROC enroll.event (EVENT e, VAL INT count)
  --{{{  
  SEQ
    e[active] := e[active] + count
    e[count] := e[count] + count
  --}}}
:
--}}}

--{{{  INLINE PROC resign.event (EVENT e)
INLINE PROC resign.event (EVENT e)
  --{{{  
  --{{{  DATA TYPE QUEUE
  DATA TYPE QUEUE
    RECORD
      INT Fptr, Bptr:
  :
  --}}}
  SEQ
    e[active], e[count] := e[active] - 1, e[count] - 1
    IF
      (e[count] = 0) AND (e[active] > 0)
        SEQ
          --{{{  attach the whole (non-empty) e-queue to the run-queue
          QUEUE run:
          ASM
            LD    ADDRESSOF run                  -- run := [Fptr, Bptr]
            SAVEL
            LD    run[Fptr]                      -- run queue empty?
            MINT
            DIFF
            CJ    :L1                            -- yes
          
            LD    e[Fptr]                        -- run[Bptr]^[EVENT.pw.Link] := e[Fptr]
            LD    run[Bptr]
            STNL  EVENT.pw.Link
            J     :L2
          
            :L1
            LD    e[Fptr]                        -- Bptr := e[Fptr]
            STLF
          
            :L2
            LD    e[Bptr]                        -- Fptr := e[Bptr]
            STLB
          --}}}
          e := [EVENT.NotProcess.p, EVENT.NotProcess.p, e[active], e[active]]
      TRUE
        SKIP
  --}}}
:
--}}}

--{{{  INLINE PROC synchronise.event (EVENT e)
INLINE PROC synchronise.event (EVENT e)
  --{{{  don't reschedule if last one
  --{{{  DATA TYPE QUEUE
  DATA TYPE QUEUE
    RECORD
      INT Fptr, Bptr:
  :
  --}}}
  SEQ
    e[count] := e[count] - 1
    IF
      e[count] = 0
        SEQ
          --{{{  attach the whole e-queue to the run-queue
          IF
            e[Fptr] <> EVENT.NotProcess.p
              --{{{  attach the whole (non-empty) e-queue to the run-queue
              QUEUE run:
              ASM
                LD    ADDRESSOF run                  -- run := [Fptr, Bptr]
                SAVEL
                LD    run[Fptr]                      -- run queue empty?
                MINT
                DIFF
                CJ    :L1                            -- yes
              
                LD    e[Fptr]                        -- run[Bptr]^[EVENT.pw.Link] := e[Fptr]
                LD    run[Bptr]
                STNL  EVENT.pw.Link
                J     :L2
              
                :L1
                LD    e[Fptr]                        -- Fptr := e[Fptr]
                STLF
              
                :L2
                LD    e[Bptr]                        -- Bptr := e[Bptr]
                STLB
              --}}}
            TRUE
              SKIP
          --}}}
          e := [EVENT.NotProcess.p, EVENT.NotProcess.p, e[active], e[active]]
      TRUE
        SEQ
          --{{{  enqueue this process on e-queue
          IF
            e[Fptr] = EVENT.NotProcess.p
              ASM
                LDLP  0
                ST    e[Fptr]
                LDLP  0
                ST    e[Bptr]
            TRUE
              ASM
                LDLP  0
                LD    e[Bptr]
                STNL  EVENT.pw.Link
                LDLP  0
                ST    e[Bptr]
          --}}}
          --{{{  save instruction pointer and schedule next process
          ASM
            STOPP
          --}}}
  --}}}
:
--}}}
