--{{{  some constants
VAL INT less IS -1:
VAL INT same IS 0:
VAL INT more IS 1:
VAL BYTE BELL IS 7(BYTE):
VAL BYTE NULL IS 0(BYTE):
VAL BYTE BACK IS 8(BYTE):
VAL BYTE DELETE IS 127(BYTE):
VAL BYTE FLUSH IS 255(BYTE):
--}}}

--{{{  out stuff
PROC out.repeat (VAL BYTE ch,  VAL INT n,  CHAN OF BYTE out)
  --{{{
  IF
    n > 0
      SEQ i = 0 FOR n
        out ! ch
    TRUE
      SKIP
  --}}}
:

PROC out.ch (VAL BYTE ch,  VAL INT field,  CHAN OF BYTE out)
  --{{{
  SEQ
    out.repeat (' ', field - 1, out)
    out ! ch
  --}}}
:

PROC out.ch.funny (VAL BYTE ch,  VAL INT field,  CHAN OF [1]BYTE out)
  --{{{
  SEQ
    VAL [1]BYTE thing RETYPES ch:
    out ! thing
  --}}}
:

PROC in.ch (BYTE ch, CHAN OF BYTE in)
  --{{{
  in ? ch
  --}}}
:

PROC out.bell (CHAN OF BYTE out)
  --{{{
  out.ch (BELL, 1, out)
  --}}}
:

PROC out.number (VAL INT n,  VAL INT field,  CHAN OF BYTE out)
  --{{{
  VAL max.digits IS 20:
  [max.digits]INT D:
  INT x, i:
  IF
    (n = 0)
      --{{{  zero
      SEQ
        IF
          (1 < field)
            out.repeat (' ', field - 1, out)
          (TRUE)
            SKIP
        out ! '0'
      --}}}
    (TRUE)
      SEQ
        --{{{  check negative
        IF
          (n < 0)
            x := n
          (TRUE)         -- (n > 0)
            x := -n
        --}}}
        --{{{  decompose
        i := 0
        WHILE x < 0
          SEQ
            D [i] := x\10
            x := x/10
            i := i + 1
        --}}}
        --{{{  pad
        IF
          (n > 0)
            out.repeat (' ', field - i, out)
          (TRUE)
            SEQ
              out.repeat (' ', (field - 1) - i, out)
              out ! '-'
        --}}}
        --{{{  output
        WHILE i > 0
          SEQ
            i := i - 1
            out ! BYTE ( (INT '0') -(D [i]))
        --}}}
  --}}}
:

PROC out.string (VAL []BYTE s,  VAL INT field,  CHAN OF BYTE out)
  --{{{
  VAL length IS SIZE s:
  SEQ
    out.repeat (' ', field - length, out)
    SEQ i = 0 FOR length
      SEQ
        out ! s [i]
  --}}}
:

PROC out.bool (VAL BOOL b,  VAL INT field,  CHAN OF BYTE out)
  --{{{
  IF
    (b = TRUE)
      out.ch ('1', field, out)
    (b = FALSE)
      out.ch ('0', field, out)
    (TRUE)
      out.ch ('.', field, out)
  --}}}
:

PROC out.yes.no (VAL BOOL b,  VAL INT field,  CHAN OF BYTE out)
  --{{{
  IF
    b
      out.string ("yes", field, out)
    TRUE
      out.string ("no", field, out)
  --}}}
:

PROC black.hole (CHAN OF BYTE in)
  --{{{
  WHILE TRUE
    BYTE any:
    in ? any
  --}}}
:
--}}}
